// icextwindow.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2001, 2004                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//////////////////////////////////////////////////////////////////////
//  functions for launching other secondary windows
//////////////////////////////////////////////////////////////////////
//START NON-TRANSLATABLE
function showPrintable(nLevel){
	var sDBCollection="dbmult:ddp:db2:ddm";
	var sBRMSCollection="rzai8:rzaj1";
	var sAvailCollection="rzamp:rzahr";
	var sPackage="";
	var bFound=false;
	strTopicPath= top.text.location.pathname.toString( );
	delimiter = (strTopicPath.toLowerCase().indexOf("/") != -1) ? "/" : (strTopicPath.toLowerCase().indexOf("\\") != -1) ? "\\" : alert("error in filepath");
	arTopicPath= strTopicPath.split(delimiter);

	for (i = 0; i < arTopicPath.length & !bFound; i++) {
		// if we found the 'info' dir and there are at least 2 more array elements (another dir and a filename) then proceed.
		if (arTopicPath[i] == "info" && i+2 <= arTopicPath.length - 1) {
			sPackage = arTopicPath[i+1];
			bFound=true;
		}
	}
	top.dump("showPrintable(): strTopicPath = "+strTopicPath+"\ndelimiter = "+delimiter+"\nbFound = "+bFound+"\nsPackage = "+sPackage);
	
	// some topic collections don't have their own 'print this topic' page and share one with another collection
	if (sDBCollection.indexOf(sPackage) != -1) sPackage="rzatc";
	else if (sBRMSCollection.indexOf(sPackage) != -1) sPackage="rzaiu";
	else if (sAvailCollection.indexOf(sPackage) != -1) sPackage="rzalw";
	// synch the navigation
	top.navFrame.appletFrame.document.IcClient.openURL("./info/pdf_table/launcher.htm");
	// call the launcher page which will call the servlet
	if (bFound) 
		top.text.location = top.url_base+"/info/pdf_table/launcher.htm?field=filename&query="+sPackage; // send the args
	else 
		top.text.location = top.url_base+"/info/pdf_table/launcher.htm";  // just open the whole table
}

// 24Nov2003 - dvb - changed following 6 functions to use top.base_url to specify the filename.
function customizeInterface(nLevel){
	filename = top.url_base+"/info/iccustomize.htm";
	newCustomizeWindow(filename, 375, 600);
}
function changeVersion(nLevel){
	filename = top.url_base+"/../languages.htm";
	newLangVersionWindow(filename, 550, 750);
}
function changeLocalVersion(nLevel){
	filename = top.url_base+"/info/rzah8selectversion.htm";
	newLangVersionWindow(filename, 550, 750);
}
function sendFeedback(nLevel){
	filename = top.url_base+"/info/icfeedback.htm";
	newFeedbackWindow(filename, 375, 600);
}
function advancedLocalSearch(){
	filename = top.url_base+"/info/icsearchadv.htm";
	newSearchWindow(filename, 600, 400);
}
function advancedSearch(){
	filename = top.url_base+"/info/icsearchwebadv.htm";
	newSearchWindow(filename, 600, 400);
}
//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
//  support functions for the above 'public' functions
//////////////////////////////////////////////////////////////////////
/*TRNOTE: The following text strings are displayed in a popup window when a 
  user clicks on a link in the masthead or footer that goes to a required IBM.COM page. */

function confirmLeave(site){
	var sResult = "Odcházíte z aplikace Information Center a přecházíte na webové stránky "+site+"\nChcete pokračovat?";
	return confirm(sResult);
}
function confirmNew(site){
	var sResult = "Otevře se nové okno prohlížeče s webovými stránkami "+site+"\nChcete pokračovat?";
	return confirm(sResult);
}
//START NON-TRANSLATABLE
function closeChildren(){
    // define list of windows we want to close when we exit/leave the site
    var arWindows = new Array;
    arWindows.push(aCustomizeWindow);
    arWindows.push(aFeedbackWindow);
    //arWindows.push(aLangVersionWindow);
    arWindows.push(aMovieWindow);
    arWindows.push(aMovieWindowV2);
    arWindows.push(aPopupWindow);
    arWindows.push(aSearchWindow);
    arWindows.push(searchResultsWindow);
    arWindows.push(searchResultsWindowInternet);
    arWindows.push(searchResultsWindowInternetLucene);
    
    // click through window list array and close open windows
    for ( var i = 0; i < arWindows.length; i++ ) {
        wnd = arWindows[i];
        if (wnd != null && !(wnd.closed)) {
            top.dump("icextwindow.js: closeChildren(): Found "+wnd.name+ " exists and not closed.  Closing it.");
            wnd.close();
            }
    }
}

function newWindow (theURL){
	if ( !confirmNew(theURL)) return;
	aWindow=window.open(theURL,"_blank",'titlebar=yes,location=yes,toolbar=yes,scrollbars=yes,resizable=yes,width=780,height=450,status=yes');
}
function newChildWindow (theURL, theWidth, theHeight)
{
	if ((theWidth != null)&(theHeight != null)){
		theSize = 'width='+theWidth+',height='+theHeight
		aWindow=window.open(theURL,"childWindow",theSize);
	} else {
		aWindow=window.open(theURL,"childWindow", 'titlebar=no,location=no,toolbar=no,scrollbars=yes,resizable=yes,status=no');
	}	
	if(aWindow != null)	{
        if(aWindow.opener == null) {
            aWindow.opener = self;
        };
    }
}
var aPopupWindow=null;
function popupWindow(theURL, theWidth, theHeight) {
	var bExists=false;
	if (aPopupWindow != null && !(aPopupWindow.closed)) {
		bExists=true;
	}
	nWidth = (theWidth == null)? 500 : theWidth;
	nHeight = (theHeight == null)? 200 : theHeight;
	sAttributes = 'width='+nWidth+',height='+nHeight+',scrollbars=yes,alwaysRaised=yes';
	aPopupWindow=window.open(theURL,"popupWindow",sAttributes);
	if(aPopupWindow != null) {
        if(aPopupWindow.opener == null) {
            aPopupWindow.opener = self;
        }
	}
	aPopupWindow.focus();
	if (bExists){
		nPadW=5;
		nPadH=25; 
		aPopupWindow.resizeTo(nWidth+nPadW, nHeight+nPadH);
	}
}

var aMovieWindow=null;
function movieWindow(theURL, theWidth, theHeight) {
	nWidth = (theWidth == null)? 528 : theWidth;
	nHeight = (theHeight == null)? 357 : theHeight;
	sAttributes = 'width='+nWidth+',height='+nHeight+',scrollbars=auto,alwaysRaised=yes,resizable,dependent';
	aMovieWindow=window.open(theURL,"movieWindow",sAttributes);
	if(aMovieWindow != null) {
        if(aMovieWindow.opener == null) {
            aMovieWindow.opener = self;
        }
	}
	aMovieWindow.focus();
	nPadW=5;
	nPadH=25; 
//	top.dump("movieWindow setting size to : w "+nWidth+nPadW+" h "+nHeight+nPadH);
	aMovieWindow.resizeTo(nWidth+nPadW, nHeight+nPadH);
}
var OLDaMovieWindow=null;
function OLDmovieWindow(theURL, theWidth, theHeight) {
	var bExists=false;
	if (aMovieWindow != null && !(aMovieWindow.closed)) {
		bExists=true;
	}
	nWidth = (theWidth == null)? 528 : theWidth;
	nHeight = (theHeight == null)? 357 : theHeight;
	sAttributes = 'width='+nWidth+',height='+nHeight+',scrollbars=auto,alwaysRaised=yes,resizable,dependent';
	aMovieWindow=window.open(theURL,"movieWindow",sAttributes);
	if(aMovieWindow != null) {
        if(aMovieWindow.opener == null) {
            aMovieWindow.opener = self;
        }
	}
	aMovieWindow.focus();
	if (bExists){
		nPadW=5;
		nPadH=25; 
		aMovieWindow.resizeTo(nWidth+nPadW, nHeight+nPadH);
	}
}
var aMovieWindowV2=null;
function movieWindowV2(theURL, theWidth, theHeight) {
	var bExists=false;
	if (aMovieWindowV2 != null && !(aMovieWindowV2.closed)) {
		bExists=true;
	}
	nWidth = (theWidth == null)? 350 : theWidth;
	nHeight = (theHeight == null)? 320 : theHeight;
	sAttributes = 'width='+nWidth+',height='+nHeight+',scrollbars=auto,alwaysRaised=yes,resizable,dependent';
	aMovieWindowV2=window.open(theURL,"movieWindow",sAttributes);
	if(aMovieWindowV2 != null) {
        if(aMovieWindowV2.opener == null) {
            aMovieWindowV2.opener = self;
        }
	}
	aMovieWindowV2.focus();
	if (bExists){
		nPadW=5;
		nPadH=25; 
		aMovieWindowV2.resizeTo(nWidth+nPadW, nHeight+nPadH);
	}
}


var aCustomizeWindow=null;
function newCustomizeWindow (theURL, theWidth, theHeight) {
	if (aCustomizeWindow != null && !aCustomizeWindow.closed) {
		aCustomizeWindow.focus();
	} else {
		if ((theWidth != null)&(theHeight != null)){
			theSize = 'width='+theWidth+',height='+theHeight+',scrollbars=yes,resizable=yes'
			aCustomizeWindow=window.open(theURL,"customizeWindow",theSize);
		} else {
			aCustomizeWindow=window.open(theURL,"customizeWindow", 'titlebar=no,location=no,toolbar=no,scrollbars=yes,resizable=yes,status=no');
		}	
		if(aCustomizeWindow != null)	{
	        if(aCustomizeWindow.opener == null) {
	            aCustomizeWindow.opener = this;
	        }
		}
	}	
}

// 16Feb2004 - dvb - removed the use of the sizes and other restrictions on the browser window. 
//           This will create a new browser window that is 'full featured' with toolbar etc.  
//           This is so that the languages.htm can just reload its window with the new page and still get a functional browser.
var aLangVersionWindow=null;
function newLangVersionWindow (theURL, theWidth, theHeight) {
	if (aLangVersionWindow != null && !aLangVersionWindow.closed) {
		aLangVersionWindow.focus();
	} else {
//		if ((theWidth != null)&(theHeight != null)){
//			theSize = 'width='+theWidth+',height='+theHeight+',scrollbars=yes,resizable=yes'
//			aLangVersionWindow=window.open(theURL,"languageVersionWindow",theSize);
//		} else {
//			aLangVersionWindow=window.open(theURL,"languageVersionWindow", 'titlebar=no,location=no,toolbar=no,scrollbars=yes,resizable=yes,status=no');
//		}	
		// the following line replaces the above commented code
		aLangVersionWindow=window.open(theURL,"languageVersionWindow");

		if(aLangVersionWindow != null)	{
	        if(aLangVersionWindow.opener == null) {
	            aLangVersionWindow.opener = self;
	        }
		}
	}	
}

var aFeedbackWindow=null;
function newFeedbackWindow (theURL, theWidth, theHeight) {
	if (aFeedbackWindow != null && !aFeedbackWindow.closed) {
		aFeedbackWindow.focus();
	} else {
		if ((theWidth != null)&(theHeight != null)){
			theSize = 'width='+theWidth+',height='+theHeight+',scrollbars=yes,resizable=yes'
			aFeedbackWindow=window.open(theURL,"feedbackWindow",theSize);
		} else {
			aFeedbackWindow=window.open(theURL,"feedbackWindow", 'titlebar=no,location=no,toolbar=no,scrollbars=yes,resizable=yes,status=no');
		}	
		if(aFeedbackWindow != null)	{
	        if(aFeedbackWindow.opener == null) {
	            aFeedbackWindow.opener = self;
	        }
		}
	}	
}
//////////////////////////////////////////////////////////////////////
// Search functions
//////////////////////////////////////////////////////////////////////
var aSearchWindow=null;
function newSearchWindow (theURL, theWidth, theHeight) {
	if (aSearchWindow != null && !aSearchWindow.closed) {
		aSearchWindow.focus();
	} else {
		if ((theWidth != null)&(theHeight != null)){
			theSize = 'width='+theWidth+',height='+theHeight+',scrollbars=yes,resizable=yes'
			aSearchWindow=window.open(theURL,"advancedSearchWindow",theSize);
		} else {
			aSearchWindow=window.open(theURL,"advancedSearchWindow", 'titlebar=no,location=no,toolbar=no,scrollbars=yes,resizable=yes,status=no,dependent=no');
//			aSearchWindow=window.open(theURL,"advancedSearchWindow");
		}	
		if(aSearchWindow != null)	{
	        if(aSearchWindow.opener == null) {
	            aSearchWindow.opener = self;
	        }
		}
	}	
}

var searchResultsWindow=null;
function check_search(form) {
	if (searchResultsWindow != null && !searchResultsWindow.closed) {
		searchResultsWindow.focus();
	} else {
		if (top.isOP5) filename="./info/icsearchresultswait.htm";
		else filename="./icsearchresultswait.htm";
		searchResultsWindow=window.open(filename,"searchResultsWindow2", 'alwaysRaised=yes,dependent=no,width=250,height=400,titlebar=no,location=no,toolbar=no,scrollbars=yes,resizable=yes,status=no');
		if(searchResultsWindow != null)	{
        	if(searchResultsWindow.opener == null) {
           		searchResultsWindow.opener = self;
	        }
		}
	}
	form.target="searchResultsWindow2";
}
// global variables are required to make the next two functions work
var searchResultsWindowInternet=null;
var nSearchCloseID=0;
var strSearchTerms="";
var strSearchVersion="";
var objForm=null;
var bSearchResultsWrapperLoaded=false;
function check_search_internet(form, searchVersion) {
	bResult = true;
	form.target="searchresultsframe";
	strSearchVersion = searchVersion;
	if (searchResultsWindowInternet != null && !searchResultsWindowInternet.closed
		&& searchResultsWindowInternet.searchformframe) {
		searchResultsWindowInternet.focus();
		objForm = null;
		bResult = true;  // allow the current form to be submited.
	} else {
		if (top.isOP5) filename="./info/icsearchresultswait.htm";
		else filename="./icsearchresultswait.htm";
		searchResultsWindowInternet=window.open(filename,"searchResultsWindow2", 'alwaysRaised=yes,dependent=no,width=400,height=450,titlebar=no,location=no,toolbar=no,scrollbars=yes,resizable=yes,status=no');
		if(searchResultsWindowInternet != null)	{
        	if(searchResultsWindowInternet.opener == null) {
           		searchResultsWindowInternet.opener = self;
	        }
			searchResultsWindowInternet.focus();
		}
		objForm = form;
		bResult = false;  // defer processing of the search form.
	}
	strSearchTerms=form.free_text.value;
	nSearchCloseID=self.setTimeout(finalizeSearchPage,1000);
	return bResult;
}

function finalizeSearchPage(){
	if (!bSearchResultsWrapperLoaded) {
		// clear the timeout
		if (nSearchCloseID != 0) {
			self.clearTimeout(nSearchCloseID);
		}
		nSearchCloseID=self.setTimeout(finalizeSearchPage,1000);
		return;
	}
	// make sure advanced form is displayed
	if (searchResultsWindowInternet.searchformframe.document.URL.indexOf('searchadv.htm')==-1) {
		searchResultsWindowInternet.searchformframe.location="./info/rzah8searchadv.html"
	}
	// if processing deferred, submit the original form
	if (objForm != null) objForm.submit();
	// if stand-alone advanced search panel open, then close it.
	if (strSearchVersion == 'advanced' && aSearchWindow != null && !aSearchWindow.closed) {
		aSearchWindow.close();
	}
	// set the text within the search panel.
	searchResultsWindowInternet.searchformframe.initForm(strSearchTerms);
	// clear the timeout
	if (nSearchCloseID != 0) {
		self.clearTimeout(nSearchCloseID);
	}
}
function searchResultsWrapperLoaded(bValue){
	bSearchResultsWrapperLoaded=bValue;
}

var searchResultsWindowInternetLucene=null;
function check_search_internet_lucene(form, searchVersion) {
	bResult = true;
	form.target="results";
//	strSearchVersion = searchVersion;
	if (searchResultsWindowInternetLucene != null && !searchResultsWindowInternetLucene.closed
		&& searchResultsWindowInternetLucene.searchformframe) {
		searchResultsWindowInternetLucene.focus();
//		objForm = null;
//		bResult = true;  // allow the current form to be submited.
	} else {
		if (top.isOP5) filename="./info/icsearchresultswait.htm";
		else filename="./icsearchresultswait.htm";
		searchResultsWindowInternetLucene=window.open(filename,"results", 'alwaysRaised=yes,dependent=no,width=400,height=450,titlebar=no,location=no,toolbar=no,scrollbars=yes,resizable=yes,status=no');
		if(searchResultsWindowInternetLucene != null)	{
        	if(searchResultsWindowInternetLucene.opener == null) {
           		searchResultsWindowInternetLucene.opener = self;
	        }
			searchResultsWindowInternetLucene.focus();
		}
//		objForm = form;
//		bResult = false;  // defer processing of the search form.
	}
//	strSearchTerms=form.free_text.value;
//	nSearchCloseID=self.setTimeout(finalizeSearchPage,1000);
	return bResult;
}
//END NON-TRANSLATABLE

